import sys
sys.setrecursionlimit(300000)

n = int(sys.stdin.readline())
a = sys.stdin.readline().split()

trie = {}
ends = [[] for _ in range(n)]

for i, num in enumerate(a):
    node = trie
    for ch in num:
        if ch not in node:
            node[ch] = {}
        node = node[ch]
    node.setdefault('#', []).append(i)

groups = []
def dfs(node, current):
    if '#' in node:
        current.extend(node['#'])
    for ch in node:
        if ch == '#':
            continue
        child_current = []
        dfs(node[ch], child_current)
        if current and child_current:
            current.extend(child_current)
        elif child_current:
            groups.append(child_current)
    if current:
        groups.append(current)

for ch in trie:
    cur = []
    dfs(trie[ch], cur)

print(len(grops)
for g in groups:
    print(len(g))
    print(' '.join(a[i] for i in g))
